﻿//////////////////////////////////////////////
// DataAllocator.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	// Clipboards
	class Clipboard ;

	// Components
	class Button ;
	class CheckBox ;
	class ComboBox ;
	class ContextMenu ;
	class EditBox ;
	class FileExplorer ;
	class GroupBox ;
	class ImageDisplay ;
	class ListBox ;
	class LogWin ;
	class MultiLineEdit ;
	class ProgressBar ;
	class ScrollBar ;
	class Slider ;
	class Static ;
	class TabWindow ;
	class ToolBar ;
	class TreeView ;
	class Window ;

	// Cursors
	class Cursor ;

	// Fonts
	class Font ;

	// Images
	class Image ;

	// Layouts
	class LayoutResizeHandle ;

	// Notificators
	class Notificator ;

	// Systems
	class System ;
}

/// Class ------------------------------------

namespace nkWinUi
{
	class DataAllocator
	{
		public :

			// Constructeur, destructeur
			DataAllocator (System* system) noexcept ;
			virtual ~DataAllocator () ;

			// Allocations
			// Clipboards
			virtual Clipboard* allocateClipboard () const = 0 ;

			// Components
			virtual Button* allocateButton () const = 0 ;
			virtual CheckBox* allocateCheckBox () const = 0 ;
			virtual ComboBox* allocateComboBox () const = 0 ;
			virtual ContextMenu* allocateContextMenu () const = 0 ;
			virtual EditBox* allocateEditBox () const = 0 ;
			virtual FileExplorer* allocateFileExplorer () const = 0 ;
			virtual GroupBox* allocateGroupBox () const = 0 ;
			virtual ImageDisplay* allocateImageDisplay () const = 0 ;
			virtual ListBox* allocateListBox () const = 0 ;
			virtual LogWin* allocateLogWin () const = 0 ;
			virtual MultiLineEdit* allocateMultiLineEdit () const = 0 ;
			virtual ProgressBar* allocateProgressBar () const = 0 ;
			virtual ScrollBar* allocateScrollBar () const = 0 ;
			virtual Slider* allocateSlider () const = 0 ;
			virtual Static* allocateStatic () const = 0 ;
			virtual TabWindow* allocateTabWindow () const = 0 ;
			virtual ToolBar* allocateToolBar () const = 0 ;
			virtual TreeView* allocateTreeView () const = 0 ;
			virtual Window* allocateWindow () const = 0 ;

			// Cursors
			virtual Cursor* allocateCursor () const = 0 ;

			// Fonts
			virtual Font* allocateFont () const = 0 ;

			// Images
			virtual Image* allocateImage () const = 0 ;

			// Layouts
			virtual LayoutResizeHandle* allocateLayoutResizeHandle () const = 0 ;

			// Notificators
			virtual Notificator* allocateNotificator () const = 0 ;

		protected :

			System* _system ;
	} ;
}